import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  updateQueryBuilder,
  getRecord,
  uploadFile,
} from "../helper/general.js";
import Announcement from "../sequelize/announcementSchema.js";
import { createQueryBuilder } from "../helper/queryBuilder.js";

/** Function to create or update Announcement */
export const createUpdateAnnouncement = async (req, res) => {
  const { id, title, start_date, end_date } = req.body;
  console.log("req.body========", req.body)
  console.log("req.files?.attachment======", req.files?.attachment)
  req.body.id = id ? parseInt(id) : null;

  let attachment;
  if (req.files && req.files?.attachment) {
    attachment = await uploadFile("announcement", req.files.attachment);
  }

  if (id) {
    req.body.updated_by = req.user.sessionid;
    req.body.attachment = req.body.attachment ? req.body.attachment :`${process.env.HARMONY_BACKEND_URL}/${attachment}`;
    /**Update Announcement Query */
    const { query, values } = updateQueryBuilder(Announcement, req.body);
    await db.query(query, values);
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "Announcement",
      `This user updated Announcement with id: ${id}`
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    req.body.created_by = req.user.sessionid;
    req.body.attachment = attachment ? `${process.env.HARMONY_BACKEND_URL}/${attachment}` : null;
    const [record] = await getRecord("announcement", "title", title);
    if (record) {
      return sendResponse(res, 400, "Record with same title already exists");
    }
    /**Insert record for Announcement */
    const { query, values } = createQueryBuilder(Announcement, req.body);
    const [createAnnouncement] = await db.query(query, values);
    await insertActivityLog(req.user.sessionid, "create", "Announcement", createAnnouncement.insertId);
    return sendResponse(res, 200, "Record created successfully");
  }
};

export const viewAllAnnouncement = async (req, res) => {
  const { id, start_date, end_date, all } = req.query;
  const today = new Date().toISOString().slice(0, 10);

  // Set up the condition based on the provided parameters
  const condition = await whereCondition({
    table: "announcement",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    grouped: req.query.grouped,
    // user: req.user,
  });

  const searchTableName = [
    "announcement.title",
    "announcement.start_date",
    "announcement.end_date",
    "createdUser.name",
  ];

  /** If value comes with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /** Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = announcement.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  /** Handle date conditions based on 'all' parameter */
  let dateCondition = "";
  if (req.query?.isDate) {
    if (all === "false" || !all) {
      // If all is false or not provided, filter by today's date
      dateCondition = `AND announcement.start_date <= '${today}' AND announcement.end_date >= '${today}'`;
    } else if (start_date && end_date) {
      // If specific date range is provided with all=true
      dateCondition = `AND announcement.start_date >= '${start_date}' AND announcement.end_date <= '${end_date}'`;
    }
  }
  // If all=true and no dates provided, no date condition will be applied

  /** Add condition to fetch by ID if provided */
  let idCondition = "";
  if (id) {
    idCondition = `AND announcement.id = '${id}'`;
  }

  /** Record of all alerts */
  const announcementDataFetchQuery = `SELECT announcement.*, 
    createdUser.name as created_by,
    createdUser.surname as created_by_surname,
    createdUser.id as created_by_id,
    createdUser.profile as created_by_profile
    FROM announcement  
    ${joinsRecord} 
    WHERE announcement.deleted = 0 ${searchCondition} ${dateCondition} ${idCondition} ${condition}`;

  // console.log('announcementDataFetchQuery: ', announcementDataFetchQuery);
  const [announcementDataFetch] = await db.query(announcementDataFetchQuery);
  for (const element of announcementDataFetch) {
    if(element.attachment) {
      // element.attachment = `${process.env.HARMONY_BACKEND_URL}/${element.attachment}`
      element.attachment = `${element.attachment}`
    }
  }

  // if (announcementDataFetch.length == 0) {
  //   return sendResponse(res, 400, "Announcement not found");
  // }

  /** Count all records */
  const totalRecord = await countQueryCondition(announcementDataFetchQuery);

  return sendResponse(res, 200, announcementDataFetch, totalRecord);
};

// /**Function to delete a specific License */
export const deleteAnnouncement = async (req, res) => {
  const { id } = req.params;
  if (!id) {
    return sendResponse(res, 400, "Announcement id is required");
  }
  const [announcement] = await getRecord("announcement", "id", id);
  if (!announcement) {
    return sendResponse(res, 400, "Announcement not found");
  }
  const deleteRecordQuery = await db.query(`UPDATE announcement SET deleted = 1 WHERE id = ?`, [id]);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Announcement", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
